/***************************************************************************
                          helper.h  -  description
                             -------------------
    begin                : Fri Jan 3 2003
    copyright            : (C) 2003 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <vector>
 
#include <LOW_exception.h>
#include <LOW_device.h>
#include <LOW_network.h>
#include <LOW_helper_msglog.h>


#define MAX_MENU_ENTRIES  62

extern char         menuKeys[];


class_DERIVE_FROM_EXCEPTION( hlp_userAbort, LOW_exception);

   
int hlp_kbhit();

int hlp_getch( bool inEcho, bool inFlush);

void hlp_keyToCont();

int hlp_getMenuKey( const char *inAcceptChars);

unsigned int hlp_selectSingleOption( string inMsg, vector<string> inOptions, unsigned int inDefault);

bool hlp_selectBoolOption( string inMsg, bool inDefault);

template<class devType> void hlp_printDevList( vector<devType*> &inDevs);

template<class devType> vector<devType*> hlp_selectDevices( vector<devType*> &inDevs);

template<class devType> devType* hlp_selectSingleDevice( vector<devType*> &inDevs);

template<class devType> void hlp_getDevices( LOW_network &inNet);

template<class devType> void hlp_searchDevices( LOW_network &inNet, bool inAlarm);

unsigned int hlp_getTermLineLength();

void hlp_printDashline();


//=====================================================================================
// DEFINITIONS COMPILERS CANNOT HANDLE TO GO DIRECTLY INTO THE SOURCE
//=====================================================================================


template<class devType> void hlp_printDevList( vector<devType*> &inDevs)
{
  for ( unsigned int a=0; a<inDevs.size(); ++a) {
    std::string idStr  = inDevs[a]->getID().getRomIDString();
    std::string famStr = inDevs[a]->getFamilyName();
    LOW_helper_msglog::printMessage( "  Device #%d: %s (%s)\n", a, idStr.c_str(), famStr.c_str());
  }
  LOW_helper_msglog::printMessage( "Total %d devices.\n", inDevs.size());
}


template<class devType> vector<devType*> hlp_selectDevices( vector<devType*> &inDevs)
{
  if ( inDevs.size() > MAX_MENU_ENTRIES ) {
    LOW_helper_msglog::printError( "Too may device to handle in menu. Exiting...");
    exit( 1);
  }

  if ( inDevs.size() == 0 ) {
    LOW_helper_msglog::printMessage( "No devices available.\n");
    throw hlp_userAbort( "Device selection aborted.", __FILE__, __LINE__);
  }

  vector<bool> selected = vector<bool>( inDevs.size(), true);

  char acceptChars[MAX_MENU_ENTRIES+1];
  strncpy( acceptChars, menuKeys, inDevs.size());
  acceptChars[inDevs.size()] = 0;
  strcat( acceptChars, "\r ");
  
  bool keepLooping = true;
  while ( keepLooping ) {
    hlp_printDashline();
    for ( unsigned int a=0; a<inDevs.size(); ++a) {
      std::string idStr  = inDevs[a]->getID().getRomIDString();
      std::string famStr = inDevs[a]->getFamilyName();
      printf( "  [%s]  <%c> Device #%d: %s (%s)\n", selected[a]==true?"*":" ", menuKeys[a], a, idStr.c_str(), famStr.c_str());
    }
    printf( "\n");
    printf( "De/select, <space> to invert, <return> to finish -> ");

    int key;
    while( true ) {
      key = hlp_getch( false, true);
      if ( index( acceptChars, key) != 0 ) {
        break;
      }
    }

    if      ( key==' ' ) {
      printf( "<space>\n");
      for ( unsigned int a=0; a<selected.size(); ++a)
        selected[a] = ! selected[a];
    }
    else if ( key=='\r' ) {
      printf( "\n");
      keepLooping = false;
    }
    else {
      printf( "%c\n", key);
      unsigned int idx = index( menuKeys, key) - menuKeys;
      selected[idx] = ! selected[idx];
    }
  }

  vector<devType*> retVal;
  for ( unsigned int a=0; a<selected.size(); ++a)
    if ( selected[a] )
      retVal.push_back( inDevs[a]);

  return retVal;
}


template<class devType> devType* hlp_selectSingleDevice( vector<devType*> &inDevs)
{
  if ( inDevs.size() > MAX_MENU_ENTRIES ) {
    LOW_helper_msglog::printError( "Too may device to handle in menu. Exiting...");
    exit( 1);
  }

  if ( inDevs.size() == 0 ) {
    LOW_helper_msglog::printMessage( "No devices available.\n");
    throw hlp_userAbort( "Device selection aborted.", __FILE__, __LINE__);
  }

  char acceptChars[MAX_MENU_ENTRIES+1];
  strncpy( acceptChars, menuKeys, inDevs.size());
  acceptChars[inDevs.size()] = 0;

  hlp_printDashline();
  for ( unsigned int a=0; a<inDevs.size(); ++a) {
    std::string idStr  = inDevs[a]->getID().getRomIDString();
    std::string famStr = inDevs[a]->getFamilyName();
    printf( "  <%c> Device #%d: %s (%s)\n", menuKeys[a], a, idStr.c_str(), famStr.c_str());
  }

  printf( "\n");
  printf( "Select device -> ");

  int key;
  while( true ) {
    key = hlp_getch( false, true);
    if ( index( acceptChars, key) != 0 ) {
      break;
    }
  }

  printf( "%c\n", key);
  unsigned int selected = index( menuKeys, key) - menuKeys;

  return inDevs[selected];
}


template<class devType> void hlp_getDevices( LOW_network &inNet)
{
  vector<devType*> allDevs = inNet.template getDevices<devType>();

  hlp_printDashline();
  LOW_helper_msglog::printMessage( "GET %s devices on the whole network:\n", devType::familyName.c_str());
  hlp_printDevList( allDevs);
}


template<class devType> void hlp_searchDevices( LOW_network &inNet, bool inAlarm)
{
  vector<devType*> allDevs = inNet.template searchDevices<devType>( inAlarm);

  hlp_printDashline();
  LOW_helper_msglog::printMessage( "SEARCH %s %s devices on the whole network:\n", inAlarm==true?"ALARMING":"ALL", devType::familyName.c_str());
  hlp_printDevList( allDevs);
}

