/***************************************************************************
                          LOW_semaphoreSet.h  -  description
                             -------------------
    begin                : Mon Jul 29 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOW_SEMAPHORESET_H
#define LOW_SEMAPHORESET_H


#include "LOW_exception.h"


/** Abstract base class for sets of integer semaphores.
    Each instance represents one set of integer semaphores.

    Specific platforms dereive their implementation classes from this class.

    The instances are created by LOW_semaphoreSetFactory, following the factory
    design pattern.

    <B>Note:</B> There is no prescribed constructor. A class deriving from this
                 class should give the opportunity to specify the number of
                 semaphores in the set and their initial value.

    @see LOW_semaphoreSetFactory

    @author Harald Roelle, Helmut Reiser
 */
class LOW_semaphoreSet {

//=======================================================================================
public: 
  
  //=====================================================================================
  //
  // exceptions
  //
 
  /** Exception base class for all exceptions thrown by LOW_semaphoreSet. */
  class_DERIVE_FROM_EXCEPTION( semSet_error, LOW_exception);
  
  
  //=====================================================================================
  //
  // methods
  //

  /** Decrease a semaphore.
      @param  inSemNo  Number of the semaphore in the set.
   */  
  virtual void decSem( const unsigned int inSemNo) const = 0;
  
  /** Increase a semaphore.
      @param  inSemNo  Number of the semaphore in the set.
   */
  virtual void incSem( const unsigned int inSemNo) const = 0;

};

#endif
