/***************************************************************************
                          LOW_helper_msglog.h  -  description
                             -------------------
    begin                : Sun Jul 21 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOW_HELPER_MSGLOG_H
#define LOW_HELPER_MSGLOG_H


#include <stdint.h>
#include <stdarg.h>
#include <stdio.h>


#include "LOW_semaphoreSet.h"


/**
    @todo Documentation of class.

    @todo Finish implementation of class.

    @bug printXXX( "\n") gives "(NULL)" output.

  *@author Harald Roelle, Helmut Reiser
  */
class LOW_helper_msglog {

//=======================================================================================
public:

  //=====================================================================================
  //
  // type definitions
  //
  
  typedef enum {
    portSerial_dl,
    devDS1820_dl,
    linkLock_dl,
    all_dl  // this one MUST be the last
  } debugLevel_t;

  
  //=====================================================================================
  //
  // static methods
  //
  
  static void enableDebugLevel( const debugLevel_t inLevel, const bool isEnabled = true);
  
  /**
   * Print error message
   */
  static void printPerror( const int inErrno, const char *inFormat, ...);

  /**
   * Print error message
   */
  static void printError( const char *inFormat, ...);
  
  /**
   * Print warning
   */
  static void printWarning( const char *inFormat, ...);
  
  /**
   * Print message
   */
  static void printMessage( const char *inFormat, ...);
  
  /**
   * Print debug message
   */
  static void printDebug( const debugLevel_t inLevel, const char *inFormat, ...);


//=======================================================================================
private:
  
  //=====================================================================================
  //
  // locks
  //
  
  class msgLock {
    public:
      msgLock();
      ~msgLock();
      static LOW_semaphoreSet* semaphoreInit();
    
    private:
      static LOW_semaphoreSet  *semSet;
  };

  
  //=====================================================================================
  //
  // type definitions
  //
  
  typedef enum { msg_log, warn_log, err_log, debug_log} logType_t;
  
  
  //=====================================================================================
  //
  // static attributes
  //
  
  static bool errorOccured;
  static bool debugLevels[all_dl];

  static bool useStdMsgStream;
  static bool useStdWarnStream;
  static bool useStdErrStream;
  static bool useStdDebugStream;
  static bool useExtraMsgStream;
  static bool useExtraWarnStream;
  static bool useExtraErrStream;
  static bool useExtraDebugStream;
  
  static FILE* stdOutStream;
  static FILE* stdWarnStream;
  static FILE* stdErrStream;
  static FILE* stdDebugStream;
  static FILE* extraOutStream;
  static FILE* extraWarnStream;
  static FILE* extraErrStream;
  static FILE* extraDebugStream;
  
  
  //=====================================================================================
  //
  // static methods
  //
  
  static void va_printToLog( const logType_t inLogType, const char *inFormat, va_list inParamList);
  static unsigned int fprintLogHeader( FILE *inExtraStream, FILE *inStdStream);
  static void fprintfMulti( FILE *inExtraStream, FILE *inStdStream, const char *inFormat, ...);
  static void vfprintfMulti( FILE *inExtraStream, FILE *inStdStream, const char *inFormat, va_list inAp);
  static void* callocCheck( const size_t inSize);

};

#endif

