/***************************************************************************
                          LOW_semaphoreSetFactory.h  -  description
                             -------------------
    begin                : Tue Jul 30 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOW_SEMAPHORESETFACTORY_H
#define LOW_SEMAPHORESETFACTORY_H


#include "LOW_semaphoreSet.h"



/** Factory class for platform specific objects of LOW_semaphoreSet.

    This class also contains platform specific type definitions.

    @see LOW_semaphoreSet

    @author Harald Roelle, Helmut Reiser
 */
class LOW_semaphoreSetFactory {

//=======================================================================================
public: 

  //=====================================================================================
  //
  // type definitions
  //

#ifdef __linux__
  /** Linux specific type for semaphore set unique identifier. */
  typedef key_t   semSetIPCKey_t;
#endif
  
  //=====================================================================================
  //
  // static factory
  //
  
  /** Get maximum number of semaphores in set (platform aware).
      @return  Maximum number of semaphores in set.
   */
  static int getMaxSemaphoresPerSet();
  
  /** Platform aware replacement for creating dynamic instances of LOW_semaphoreSet.
      @param inSemSetIPCKey  Unique identifier for new shared memory segment.
                             To get such an identifier see LOW_IPCKeyGenerator.
      @param inCount         Number of semaphores in set.
      @param inInit          Initial values of semaphores.
      @return  Pointer to new instance of LOW_semaphoreSet.
   */
  static LOW_semaphoreSet* new_semaphoreSet( const semSetIPCKey_t inSemSetIPCKey,
                                             unsigned int inCount, unsigned int inInit);
};

#endif
