/***************************************************************************
                          LOW_IPCKeyGenerator_SysV.cpp  -  description
                             -------------------
    begin                : Tue Jul 30 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
#include <sys/types.h>
#include <sys/ipc.h>
 
#include "LOW_IPCKeyGenerator_SysV.h"


//=====================================================================================
//
// methods
//
  
LOW_semaphoreSetFactory::semSetIPCKey_t LOW_IPCKeyGenerator_SysV::getSemSetKey(  const LOW_portSerialFactory::portSpecifier_t &inSerPortSpec)
{
  return ftok( inSerPortSpec.c_str(), 1);
}


LOW_semaphoreSetFactory::semSetIPCKey_t LOW_IPCKeyGenerator_SysV::getSemSetKey(  const LOW_deviceID &inDevID)
{
  LOW_deviceIDRaw::devSerNum_t  serial;
  inDevID.getSerialNum( serial);
  return (serial[3]<<24) | (serial[2]<<16) | (serial[1]<<8) | serial[0];
}

  
LOW_sharedMemSegmentFactory::sharedMemSegmentIPCKey_t LOW_IPCKeyGenerator_SysV::getSharedMemKey(  const LOW_portSerialFactory::portSpecifier_t &inSerPortSpec)
{
  return ftok( inSerPortSpec.c_str(), 2);
}
