/***************************************************************************
                          LOW_link.cpp  -  description
                             -------------------
    begin                : Sun Jul 7 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
#include "LOW_link.h"
#include "LOW_helper_msglog.h"


//=====================================================================================
//
// static attributes
//

LOW_link::linkID_t  LOW_link::linkCounter = 0;



//=====================================================================================
//
// constructors
//

LOW_link::LOW_link( const bool inHasProgramPulse, const bool inHasOverDrive,
                    const bool inHasExternalPower, const bool inAllowProgPulse) :
  linkID(linkCounter++),
  hasProgramPulse( inHasProgramPulse),
  hasOverDrive( inHasOverDrive),
  hasExternalPower( inHasExternalPower),
  allowProgPulse( inAllowProgPulse)
{
  aquireCount = 0;
  aquirePID   = 0;
}


LOW_link::~LOW_link()
{
}



//=====================================================================================
//
// locks
//

LOW_link::commLock::commLock( LOW_link &inLink) :
  link( inLink)
{
  link.semSet->decSem( counterSemNo);
  if ( link.aquirePID==LOW_platformMisc::getThreadID() && link.aquireCount>0 ) {  // we already have the lock semaphore
    ++link.aquireCount;
    link.semSet->incSem( counterSemNo);
    return;
  }
  link.semSet->incSem( counterSemNo);

  link.semSet->decSem( lockSemNo);

  link.semSet->decSem( counterSemNo);
  ++link.aquireCount;
  link.aquirePID = LOW_platformMisc::getThreadID();
  link.semSet->incSem( counterSemNo);
  
  LOW_helper_msglog::printDebug( LOW_helper_msglog::linkLock_dl, "Lock aquired", __FILE__, __LINE__);
}


LOW_link::commLock::~commLock()
{
  link.semSet->decSem( counterSemNo);

  if ( link.aquirePID!=LOW_platformMisc::getThreadID() ) {
    link.semSet->incSem( counterSemNo);
    throw internal_error( "FATAL: foreign process trying to releaseLock()", __FILE__, __LINE__);
  }
  
  if ( link.aquireCount == 0 ) {
    link.semSet->incSem( counterSemNo);
    throw internal_error( "FATAL: unbalanced releaseLock()", __FILE__, __LINE__);
  }

  --link.aquireCount;
  if ( link.aquireCount == 0 ) {
    link.aquirePID = 0;
    link.semSet->incSem( lockSemNo);
    LOW_helper_msglog::printDebug( LOW_helper_msglog::linkLock_dl, "Lock released", __FILE__, __LINE__);
  }
  
  link.semSet->incSem( counterSemNo);
}




//=====================================================================================
//
// operator overloading
//
  
bool LOW_link::operator==(LOW_link &inLink) const
{
  return (linkID==inLink.linkID);
}


  
//=====================================================================================
//
// methods
//

uint32_t LOW_link::getID() const
{
  return linkID;
}


bool LOW_link::getHasExternalPower() const
{
  return hasExternalPower;
}

